@extends('layouts.app')

@section('title', 'SAM Bans')

@section('content')
<div class="sam-bans-container">
    <!-- Header Section -->
    <div class="sam-bans-header">
        <div class="sam-bans-title-section">
            <h1 class="sam-bans-title">
                <i class="fas fa-shield-alt"></i>
                SAM Bans Management
            </h1>
            <p class="sam-bans-subtitle">View and manage player bans from your game servers</p>
        </div>

        <!-- Statistics Cards -->
        <div class="sam-bans-stats">
            <div class="sam-stat-card">
                <div class="sam-stat-icon sam-stat-danger">
                    <i class="fas fa-ban"></i>
                </div>
                <div class="sam-stat-content">
                    <div class="sam-stat-number">{{ number_format($stats['total_bans']) }}</div>
                    <div class="sam-stat-label">Total Bans</div>
                </div>
            </div>

            <div class="sam-stat-card">
                <div class="sam-stat-icon sam-stat-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="sam-stat-content">
                    <div class="sam-stat-number">{{ number_format($stats['active_bans']) }}</div>
                    <div class="sam-stat-label">Active Bans</div>
                </div>
            </div>

            <div class="sam-stat-card">
                <div class="sam-stat-icon sam-stat-info">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="sam-stat-content">
                    <div class="sam-stat-number">{{ number_format($stats['expired_bans']) }}</div>
                    <div class="sam-stat-label">Expired Bans</div>
                </div>
            </div>

            <div class="sam-stat-card">
                <div class="sam-stat-icon sam-stat-danger">
                    <i class="fas fa-infinity"></i>
                </div>
                <div class="sam-stat-content">
                    <div class="sam-stat-number">{{ number_format($stats['permanent_bans']) }}</div>
                    <div class="sam-stat-label">Permanent</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Controls Section -->
    <div class="sam-bans-controls">
        <div class="sam-controls-left">
            <!-- Status Filter -->
            <div class="sam-filter-group">
                <label for="status-filter" class="sam-filter-label">Status:</label>
                <select id="status-filter" class="sam-filter-select" onchange="updateFilters()">
                    <option value="active" {{ $status === 'active' ? 'selected' : '' }}>Active Bans</option>
                    <option value="expired" {{ $status === 'expired' ? 'selected' : '' }}>Expired Bans</option>
                    <option value="all" {{ $status === 'all' ? 'selected' : '' }}>All Bans</option>
                </select>
            </div>

            <!-- Per Page Filter -->
            <div class="sam-filter-group">
                <label for="per-page-filter" class="sam-filter-label">Show:</label>
                <select id="per-page-filter" class="sam-filter-select" onchange="updateFilters()">
                    <option value="10" {{ $perPage == 10 ? 'selected' : '' }}>10</option>
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                </select>
                <span class="sam-filter-label">per page</span>
            </div>
        </div>

        <div class="sam-controls-right">
            <!-- Search -->
            <div class="sam-search-group">
                <div class="sam-search-container">
                    <input type="text" 
                           id="search-input" 
                           class="sam-search-input" 
                           placeholder="Search by SteamID, name, reason, or admin..."
                           value="{{ $search ?? '' }}">
                    <button type="button" class="sam-search-button" onclick="performSearch()">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="sam-actions">
                <a href="{{ route('sambans.players') }}" class="sam-btn sam-btn-secondary">
                    <i class="fas fa-users"></i>
                    Players
                </a>
                <a href="{{ route('sambans.statistics') }}" class="sam-btn sam-btn-info">
                    <i class="fas fa-chart-bar"></i>
                    Statistics
                </a>
            </div>
        </div>
    </div>

    <!-- Bans Table -->
    <div class="sam-bans-table-container">
        @if($bans->count() > 0)
            <div class="sam-table-wrapper">
                <table class="sam-bans-table">
                    <thead>
                        <tr>
                            <th class="sam-th-player">Player</th>
                            <th class="sam-th-steamid">SteamID</th>
                            <th class="sam-th-reason">Reason</th>
                            <th class="sam-th-admin">Admin</th>
                            <th class="sam-th-duration">Duration</th>
                            <th class="sam-th-status">Status</th>
                            <th class="sam-th-actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($bans as $ban)
                            <tr class="sam-ban-row sam-ban-{{ $ban->status }}">
                                <td class="sam-td-player">
                                    <div class="sam-player-info">
                                        <div class="sam-player-name">
                                            {{ $ban->player_name ?: $ban->player_name ?: 'Unknown Player' }}
                                        </div>
                                        @if($ban->steamid64)
                                            <a href="{{ $ban->steam_profile_url }}" 
                                               target="_blank" 
                                               class="sam-steam-link">
                                                <i class="fab fa-steam"></i>
                                            </a>
                                        @endif
                                    </div>
                                </td>

                                <td class="sam-td-steamid">
                                    <code class="sam-steamid">{{ $ban->steamid }}</code>
                                </td>

                                <td class="sam-td-reason">
                                    <div class="sam-reason" title="{{ $ban->formatted_reason }}">
                                        {{ Str::limit($ban->formatted_reason, 50) }}
                                    </div>
                                </td>

                                <td class="sam-td-admin">
                                    <div class="sam-admin-info">
                                        {{ $ban->admin_name ?: $ban->admin }}
                                    </div>
                                </td>

                                <td class="sam-td-duration">
                                    <div class="sam-duration">
                                        @if($ban->is_permanent)
                                            <span class="sam-permanent">Permanent</span>
                                        @elseif($ban->is_active)
                                            <span class="sam-time-remaining">{{ $ban->time_remaining }}</span>
                                        @else
                                            <span class="sam-expired">Expired</span>
                                        @endif
                                    </div>
                                </td>

                                <td class="sam-td-status">
                                    <span class="sam-status-badge sam-status-{{ $ban->status }}">
                                        @switch($ban->status)
                                            @case('permanent')
                                                <i class="fas fa-infinity"></i> Permanent
                                                @break
                                            @case('active')
                                                <i class="fas fa-exclamation-triangle"></i> Active
                                                @break
                                            @case('expired')
                                                <i class="fas fa-clock"></i> Expired
                                                @break
                                        @endswitch
                                    </span>
                                </td>

                                <td class="sam-td-actions">
                                    <div class="sam-action-buttons">
                                        <a href="{{ route('sambans.show', $ban->steamid) }}" 
                                           class="sam-btn sam-btn-sm sam-btn-primary"
                                           title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($ban->steamid64)
                                            <a href="{{ $ban->steam_profile_url }}" 
                                               target="_blank" 
                                               class="sam-btn sam-btn-sm sam-btn-secondary"
                                               title="Steam Profile">
                                                <i class="fab fa-steam"></i>
                                            </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="sam-pagination-wrapper">
                {{ $bans->links('sambans::partials.pagination') }}
            </div>
        @else
            <div class="sam-empty-state">
                <div class="sam-empty-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <div class="sam-empty-title">No bans found</div>
                <div class="sam-empty-text">
                    @if($search)
                        No bans match your search criteria. Try adjusting your search terms.
                    @else
                        No bans found for the selected filter.
                    @endif
                </div>
                @if($search)
                    <button type="button" class="sam-btn sam-btn-primary" onclick="clearSearch()">
                        Clear Search
                    </button>
                @endif
            </div>
        @endif
    </div>
</div>

<script>
function updateFilters() {
    const status = document.getElementById('status-filter').value;
    const perPage = document.getElementById('per-page-filter').value;
    const search = document.getElementById('search-input').value;
    
    const params = new URLSearchParams();
    if (status !== 'active') params.set('status', status);
    if (perPage !== '25') params.set('per_page', perPage);
    if (search) params.set('search', search);
    
    const url = new URL(window.location);
    url.search = params.toString();
    window.location.href = url.toString();
}

function performSearch() {
    updateFilters();
}

function clearSearch() {
    document.getElementById('search-input').value = '';
    updateFilters();
}

// Enter key search
document.getElementById('search-input').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        performSearch();
    }
});
</script>
@endsection